import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, assert_series, logical_or, logical_and

atp_tennis = read_csv_file('atp_tennis.csv')

# Calculate the performance data for each player in each round
for player in top_10_player_names:
    for round_name in rounds:
        if round_name == 'Early Round':
            # Filter the dataset to only include matches played by the player in the early rounds
            player_round_matches = grass_matches[logical_or(logical_or(logical_or(assert_series(grass_matches['Round'], '1st Round', 'equality'), assert_series(grass_matches['Round'], '2nd Round', 'equality')), assert_series(grass_matches['Round'], '3rd Round', 'equality')), assert_series(grass_matches['Round'], '4th Round', 'equality')) & logical_or(assert_series(grass_matches['Round'], player, 'equality'), assert_series(grass_matches['Round'], player, 'equality'))]
        else:
            # Filter the dataset to only include matches played by the player in the specific round
            player_round_matches = grass_matches[logical_and(assert_series(grass_matches['Round'], round_name, 'equality'), logical_or(assert_series(grass_matches['Round'], player, 'equality'), assert_series(grass_matches['Round'], player, 'equality')))]

        # Calculate the number of matches played
        matches_played = len(player_round_matches)

        # Calculate the number of matches won
        matches_won = len(player_round_matches[assert_series(player_round_matches['Winner'], player, 'equality')])

        # Calculate the win rate
        win_rate = (matches_won / matches_played) * 100 if matches_played > 0 else 0

print(win_rate)
pickle.dump(win_rate,open("./ref_result/win_rate.pkl","wb"))